﻿using System;
using System.Runtime.Serialization;
using System.Xml;
using System.Xml.Serialization;

namespace GTS.B2B.Example.Helpers
{
    /// <summary>
    /// Custom serializer. Implements an XmlObjectSerializer using a XmlSerializer in a minimalistic fashion.
    /// Useful for creating System.ServiceModel.Channels.Message objects using a XmlSerializer instead of a DataContractSerializer.
    /// </summary>
    public class B2BXMLSerializer : XmlObjectSerializer
    {
        private XmlSerializer xs;

        public B2BXMLSerializer(Type type)
        {
            xs = new XmlSerializer(type);
        }

        public override bool IsStartObject(XmlDictionaryReader reader)
        {
            throw new NotImplementedException();
        }

        public override object ReadObject(XmlDictionaryReader reader, bool verifyObjectName)
        {
            return xs.Deserialize(reader);
        }

        public override void WriteEndObject(XmlDictionaryWriter writer)
        {
            // do nothing
        }

        public override void WriteObjectContent(XmlDictionaryWriter writer, object graph)
        {
            xs.Serialize(writer, graph);
        }

        public override void WriteStartObject(System.Xml.XmlDictionaryWriter writer, object graph)
        {
            // do nothing
        }
    }
    
}
