﻿using GTS.B2B.Example.B2B.AnalysisBalance;
using GTS.B2B.Example.DataContracts.AnalysisAccountablePOSQuery;
using GTS.B2B.Example.DataContracts.AnalysisAccountablePOSResponse;
using GTS.B2B.Example.Helpers;
using System;
using System.ServiceModel;
using System.ServiceModel.Channels;

namespace GTS.B2B.Example
{
    class Program
    {
        // Starting point of application
        static void Main(string[] args)
        {
            // Call GTS B2B
            CallAnalysisAccountablePOS();
        }

        private static void CallAnalysisAccountablePOS()
        {
            // this example uses a Channelfactory to setup the connection and query the AnalysisAccountablePOS         
            // All configuration is done via de App.config               

            // Create a query
            AnalysisAccountablePOSQueryComplexType analysisAccountablePOSQuery = GetQuery();            
                        
            // make sure Message.CreateMessage uses a XmlSerializer
            B2BXMLSerializer querySerializer = new B2BXMLSerializer(typeof(AnalysisAccountablePOSQueryComplexType));

            // Create a SOAP Message
            Message analysisAccountablePOSQueryMessage = Message.CreateMessage(MessageVersion.Soap11, "http://www.gasunie.nl/mtb/cub/2010/04/20/AnalysisBalance/AnalysisAccountablePOS", analysisAccountablePOSQuery, querySerializer);            
                                            
            try
            {
				// Following statement is needed for .NET Framework 4.5.X, if you are building against 4.6 or higher then it is not needed! This makes sure TLS1.2 is used.
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;
				
                // Create the channelfactory and the channel
                ChannelFactory<AnalysisBalanceChannel> B2BFactory = new ChannelFactory<AnalysisBalanceChannel>("AnalysisBalance");
                AnalysisBalanceChannel analysisBalanceChannel = B2BFactory.CreateChannel();
                
                // Call B2B GTS and receive the response
                Message analysisAccountablePOSResponseMessage = analysisBalanceChannel.AnalysisAccountablePOS(analysisAccountablePOSQueryMessage);

                // Handle the SoapFault
                if (analysisAccountablePOSResponseMessage.IsFault)
                {                    
                    Console.WriteLine("Fault: " + analysisAccountablePOSResponseMessage.GetReaderAtBodyContents().ReadOuterXml());              
                }

                // Process the response (check Result codes etc)
                B2BXMLSerializer responseSerializer = new B2BXMLSerializer(typeof(AnalysisAccountablePOSResponseComplexType));
                AnalysisAccountablePOSResponseComplexType responseComplexType = analysisAccountablePOSResponseMessage.GetBody<AnalysisAccountablePOSResponseComplexType>(responseSerializer);

                Console.WriteLine(String.Format("Functional response:"));
                Console.WriteLine(String.Format("ResultCode: {0}", responseComplexType.Result[0].ResultCode));
                Console.WriteLine(String.Format("ResultText: {0}", responseComplexType.Result[0].ResultText));
            }
            catch (Exception e)
            {
                // Handle the exception if something goes wrong
                Console.WriteLine(String.Format("An exception has occured during querying GTS AnalaysisAccountablePOS, the error is: {0}", e.ToString()));                
            }

            Console.ReadLine();
        }

        /// <summary>
        /// Helper method to instantiate a queryComplexType object.
        /// </summary>
        /// <returns></returns>
        private static AnalysisAccountablePOSQueryComplexType GetQuery()
        {
            AnalysisAccountablePOSQueryComplexType query = new AnalysisAccountablePOSQueryComplexType();
            query.BusinessDocumentHeader = new DataContracts.AnalysisAccountablePOSQuery.BusinessDocumentHeaderComplexType();
            // note: do proper timezone conversion to +01:00 using DatetimeOffset with the ToOffset method 
            query.BusinessDocumentHeader.CreationTimestamp = DateTimeOffset.Now.ToOffset(new TimeSpan(1, 0, 0)).ToString("yyyy-MM-ddTHH:mm:ssK");
            query.BusinessDocumentHeader.MessageID = Guid.NewGuid().ToString();
            query.SetDateFrom = "2010-06-15T05:00:00+01:00";
            query.SetDateTo = "2010-06-15T13:00:00+01:00";
            query.PortfolioEdigasID = "GTS.B2B.Example Client";
            return query;
        }        
    }
}
